<?php
App::uses('AppController', 'Controller');

class LinksController extends AppController
{
    public $helpers = array('MightyLink');
    public $layout = 'member';

    /**
     *
     */
    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('view', 'ajaxAdd');
        $this->Security->unlockedActions = array('ajaxAdd');

        if (in_array($this->request->action, array('members_delete', 'admin_delete'))) {
            if ($this->request->is(array('post', 'put'))) {
                if ($this->Auth->user('account_type') == 'Demo') {
                    $this->Flash->set(__('This request is disabled into demo.'), array(
                        'element' => 'error'
                    ));
                    return $this->redirect($this->referer());
                }
            }
        }
    }
    /*
      public function isAuthorized( $user = null ) {

      // All registered users can add articles
      if ( $this->action === 'members_add' ) {
      return true;
      }

      // The owner of a link can edit and delete it
      if ( in_array( $this->action, array( 'members_edit', 'members_delete' ) ) ) {
      $linkId = (int) $this->request->params['pass'][0];

      //die( var_dump(  $this->Link->isOwnedBy( $linkId, $user[ 'id' ] ) ) );

      if ( $this->Link->isOwnedBy( $linkId, $user[ 'id' ] ) ) {
      return true;
      }
      }

      return parent::isAuthorized( $user );
      }
     */

    /**
     *
     */
    public function ajaxAdd()
    {
        $this->autoRender = false;

        $content = array(
            'status' => 'error',
            'message' => '<div class="alert alert-warning" role="alert">Something unexpected occured</div>'
        );

        if ($this->request->isAjax()) {
            sleep(1);
            $this->request->data['Link']['user_id'] = 1;
            $this->request->data['Link']['ip'] = get_ip();
            $this->request->data['Link']['bundle_id'] = 0;
            $this->request->data['Link']['redirection_type'] = 0;
            $this->request->data['Link']['password'] = '';
            $this->request->data['Link']['timer'] = 0;

            $done = 0;

            $originalLinkExist = $this->Link->originalLinkExist($this->request->data['Link']['long_url'], 1);

            if ($originalLinkExist && empty($this->request->data['Link']['alias'])) {
                $final_link = $originalLinkExist;
                $done = 1;
            }

            if (!$done) {
                if (empty($this->request->data['Link']['alias'])) {
                    $this->request->data['Link']['alias'] = $this->Link->geturl();
                }

                $this->Link->create();
                if ($this->Link->save($this->request->data)) {
                    $this->Link->User->updateAll(array('User.links' => 'User.links+1'), array('User.id' => 1));

                    $final_link = $this->Link->findById($this->Link->id);
                } else {
                    //debug($this->Link->validationErrors);
                    $Link = $this->Link->invalidFields();
                    $error = array(
                        'status' => 'error',
                        'message' => __('This link could not be saved. Please, try again.'),
                        'errors' => compact('Link')
                    );
                }
            }




            if (isset($error)) {
                $content = $error;
            } else {
                $content = array(
                    'status' => 'success',
                    'message' => $final_link['Link']['alias']
                );
            }
        }
        echo json_encode($content);
    }

    /**
     *
     * @param type $req_alias
     * @return type
     * @throws NotFoundException
     */
    public function view($req_alias)
    {
        $this->layout = 'frontend';

        $short_keyword = $req_alias;

        $link = $this->Link->find('first', array(
            //'fields' => array('Link.id', 'Link.timer', 'Link.long_url'),
            'conditions' => array('Link.alias' => $short_keyword),
        ));
        if (!$link) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('link', $link);

        $user = $this->Link->User->findById($link['Link']['user_id']);
        if (!$user) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user', $user);

        $plan_id = $user['User']['plan_id'];
        if ($link['Link']['user_id'] == 1) {
            $plan_id = Configure::read('Option.default_public_plan');
        }

        $user_plan = $this->Link->User->Plan->findById($plan_id);
        if (!$user_plan) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user_plan', $user_plan);

        $this->set('website_title', $link['Link']['title']);

        $this->set('website_description', $link['Link']['description']);

        $link_image = $link['Link']['image'];
        $this->set('og_image', $link_image);

        $this->Link->id = $link['Link']['id'];

        if ($this->request->data) {
            if ($this->request->data['password'] == $link['Link']['password']) {
                return $this->redirect($link['Link']['long_url']);
            } else {
                $this->Flash->set('Please enter a valid password.', array(
                    'element' => 'error'
                ));
            }
        } else {
            $ip = get_ip();
            $geo = $this->Link->Stat->get_geo($ip);
            $dd = $this->Link->Stat->getUserAgent();

            if (!$dd->isBot() && $dd->isBrowser()) {
                // http://book.cakephp.org/2.0/en/models/associations-linking-models-together.html#creating-and-destroying-associations-on-the-fly
                $this->Link->unbindModel(array(
                    'hasMany' => array('Stat'),
                    'belongsTo' => array('User', 'Bundle')
                ));
                $this->Link->updateAll(array('Link.clicks' => 'Link.clicks+1'), array('Link.id' => $link['Link']['id']));

                $referer = strtolower(env('HTTP_REFERER'));
                if (empty($referer) || $referer == '/') {
                    $referer = 'Direct';
                }

                $languages = $this->request->acceptLanguage();

                $stat_data = array(
                    'link_id' => $link['Link']['id'],
                    'user_id' => $user['User']['id'],
                    'ip' => $ip,
                    'continent' => $geo['continent'],
                    'country' => $geo['country'],
                    'state' => $geo['state'],
                    'city' => $geo['city'],
                    'location' => $geo['location'],
                    'browser' => ($dd->getClient('name') ? $dd->getClient('name') : 'Others'),
                    'platform' => ($dd->getOs('name') ? $dd->getOs('name') : 'Others'),
                    'device_type' => ($dd->getDeviceName() ? $dd->getDeviceName() : 'Others'),
                    'device_name' => ($dd->getModel() ? $dd->getModel() : 'Others'),
                    'device_brand' => ($dd->getBrand() ? $dd->getBrand() : 'Others'),
                    'is_mobile' => ($dd->isMobile() && !$dd->isTablet()) ? 1 : 0,
                    'is_tablet' => $dd->isTablet(),
                    'referer_domain' => (parse_url($referer, PHP_URL_HOST) ? parse_url($referer, PHP_URL_HOST) : 'Direct'),
                    'referer' => $referer,
                    'user_agent' => env('HTTP_USER_AGENT'),
                    'language' => (isset($languages[0])) ? $languages[0] : 'Others',
                    'timezone' => $geo['timezone']
                );
                $this->Link->Stat->create();
                $this->Link->Stat->save($stat_data);
            }
        }

        $plan_redirections = $user_plan['Plan']['redirections'];
        $default_redirect = $user['User']['redirection_type'];
        $link_redirect = $link['Link']['redirection_type'];

        $redirect = '';
        if ($link_redirect == 0) {
            $redirect = $default_redirect;
        } elseif (in_array($link_redirect, $plan_redirections)) {
            $redirect = $link_redirect;
        } else {
            $redirect = $default_redirect;
        }

        if ($redirect == 1) {
            return $this->redirect($link['Link']['long_url']);
        }
    }

    /**
     *
     * @return type
     * @throws NotFoundException
     */
    public function admin_index()
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Manage All Links');

        $this->Link->recursive = 0;

        if ($this->Session->check('PaginationOrder.links')) {
            $order = $this->Session->read('PaginationOrder.links');
        } else {
            $default_order = explode(':', 'Link.created:desc');
            $this->Session->write('PaginationOrder.links', $default_order);
            $order = $this->Session->read('PaginationOrder.links');
        }

        if (isset($this->request->data['paginationorder'])) {
            $new_order = explode(':', $this->request->data['paginationorder']);
            $this->Session->write('PaginationOrder.links', $new_order);
            $order = $this->Session->read('PaginationOrder.links');
        }

        $conditions = array();
        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->data['Filter'])) {
            $filter_url['controller'] = $this->request->params['controller'];
            $filter_url['action'] = $this->request->params['action'];
            // We need to overwrite the page every time we change the parameters
            $filter_url['page'] = 1;

            // for each filter we will add a GET parameter for the generated url
            foreach ($this->data['Filter'] as $name => $value) {
                if ($value) {
                    // You might want to sanitize the $value here
                    // or even do a urlencode to be sure
                    $filter_url[$name] = urlencode($value);
                }
            }
            // now that we have generated an url with GET parameters,
            // we'll redirect to that page
            return $this->redirect($filter_url);
        } else {
            // Inspect all the named parameters to apply the filters
            foreach ($this->params['named'] as $param_name => $value) {
                // Don't apply the default named parameters used for pagination
                if (!in_array($param_name, array('page', 'sort', 'direction', 'limit'))) {
                    // You may use a switch here to make special filters
                    // like "between dates", "greater than", etc

                    $search_params = array('alias');

                    if (in_array($param_name, $search_params)) {
                        $conditions[] = array(
                            array('Link.' . $param_name . ' LIKE' => '%' . $value . '%')
                        );
                    } elseif ($param_name == 'title_desc') {
                        $conditions['OR'] = array(
                            array('Link.title LIKE' => '%' . $value . '%'),
                            array('Link.description LIKE' => '%' . $value . '%'),
                            array('Link.long_url LIKE' => '%' . $value . '%')
                        );
                    } else {
                        $conditions['Link.' . $param_name] = $value;
                    }
                    $this->request->data['Filter'][$param_name] = $value;
                }
            }
        }

        $this->paginate = array(
            'conditions' => $conditions,
            'fields' => array('Link.id', 'Link.long_url', 'Link.title', 'Link.description', 'Link.alias', 'Link.timer', 'Link.password', 'Link.created', 'Link.clicks', 'User.username', 'Bundle.id', 'Bundle.name'),
            'limit' => 10,
            'order' => array(
                //'Link.created' => 'desc',
                $order[0] => $order[1]
            )
        );
        $data = $this->paginate('Link');

        $this->set('links', $data);
    }

    /**
     *
     * @return type
     */
    public function members_index()
    {
        $this->set('website_title', 'All Links');

        $this->Link->recursive = 0;

        if ($this->Session->check('PaginationOrder.links')) {
            $order = $this->Session->read('PaginationOrder.links');
        } else {
            $default_order = explode(':', 'Link.created:desc');
            $this->Session->write('PaginationOrder.links', $default_order);
            $order = $this->Session->read('PaginationOrder.links');
        }

        if (isset($this->request->data['paginationorder'])) {
            $new_order = explode(':', $this->request->data['paginationorder']);
            $this->Session->write('PaginationOrder.links', $new_order);
            $order = $this->Session->read('PaginationOrder.links');
        }


        $bundles = $this->Link->Bundle->find('list', array(
            'conditions' => array(
                'Bundle.user_id' => $this->Auth->user('id')
            ),
            'order' => 'Bundle.name ASC'
        ));
        $this->set('bundles', $bundles);


        $conditions = array();
        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->data['Filter'])) {
            $filter_url['controller'] = $this->request->params['controller'];
            $filter_url['action'] = $this->request->params['action'];
            // We need to overwrite the page every time we change the parameters
            $filter_url['page'] = 1;

            // for each filter we will add a GET parameter for the generated url
            foreach ($this->data['Filter'] as $name => $value) {
                if ($value) {
                    // You might want to sanitize the $value here
                    // or even do a urlencode to be sure
                    $filter_url[$name] = urlencode($value);
                }
            }
            // now that we have generated an url with GET parameters,
            // we'll redirect to that page
            return $this->redirect($filter_url);
        } else {
            // Inspect all the named parameters to apply the filters
            foreach ($this->params['named'] as $param_name => $value) {
                // Don't apply the default named parameters used for pagination
                if (!in_array($param_name, array('page', 'sort', 'direction', 'limit'))) {
                    // You may use a switch here to make special filters
                    // like "between dates", "greater than", etc

                    $search_params = array('alias');

                    if (in_array($param_name, $search_params)) {
                        $conditions[] = array(
                            array('Link.' . $param_name . ' LIKE' => '%' . $value . '%')
                        );
                    } elseif ($param_name == 'title_desc') {
                        $conditions['OR'] = array(
                            array('Link.title LIKE' => '%' . $value . '%'),
                            array('Link.description LIKE' => '%' . $value . '%'),
                            array('Link.long_url LIKE' => '%' . $value . '%')
                        );
                    } else {
                        $conditions['Link.' . $param_name] = $value;
                    }
                    $this->request->data['Filter'][$param_name] = $value;
                }
            }
        }

        $conditions[] = array('Link.user_id' => $this->Auth->user('id'));

        $this->paginate = array(
            'conditions' => $conditions,
            //'fields' => array('Link.id', 'Link.alias', 'Link.timer', 'Link.password', 'Link.created', 'Link.clicks', 'User.username', 'Bundle.id', 'Bundle.name'),
            'limit' => 10,
            'order' => array(
                //'Link.created' => 'desc',
                $order[0] => $order[1]
            )
        );
        $data = $this->paginate('Link');

        $this->set('links', $data);
    }

    /**
     *
     * @return type
     */
    public function members_add()
    {
        $this->set('website_title', 'Add Link');

        $bundles = $this->Link->Bundle->find('list', array(
            'conditions' => array(
                'Bundle.user_id' => $this->Auth->user('id')
            ),
            'order' => 'Bundle.name ASC'
        ));
        $this->set('bundles', $bundles);

        $user = $this->Link->User->findById($this->Auth->user('id'));
        if (!$user) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user', $user);

        $user_plan = $this->Link->User->Plan->findById($user['User']['plan_id']);
        if (!$user_plan) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user_plan', $user_plan);

        if ($this->request->is('post')) {
            $this->request->data['Link']['user_id'] = $this->Auth->user('id');

            if (!isset($this->request->data['Link']['bundle_id']) || empty($this->request->data['Link']['bundle_id'])) {
                $this->request->data['Link']['bundle_id'] = 0;
            }

            $this->request->data['Link']['ip'] = get_ip();

            $originalLinkExist = $this->Link->originalLinkExist($this->request->data['Link']['long_url'], $user['User']['id']);

            if ($originalLinkExist && empty($this->request->data['Link']['alias'])) {
                $this->set('originalLinkExist', $originalLinkExist);
                $this->Flash->set('The link has been saved.', array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'add'));
            }

            if (empty($this->request->data['Link']['alias'])) {
                $this->request->data['Link']['alias'] = $this->Link->geturl();
            }

            $this->Link->create();
            if ($this->Link->save($this->request->data)) {
                $this->Link->User->updateAll(array('User.links' => 'User.links+1'), array('User.id' => $this->Auth->user('id')));

                $this->Flash->set('The link has been saved.', array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'add'));
            } else {
                //debug($this->Link->validationErrors);
                $this->Flash->set(__('The link could not be saved. Please, try again.'), array(
                    'element' => 'error'
                ));
            }
        }
    }

    /**
     *
     * @param type $id
     * @return type
     * @throws NotFoundException
     */
    public function admin_edit($id = null)
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Edit Link');

        if (!$id) {
            throw new NotFoundException(__('Invalid Link'));
        }

        $link = $this->Link->find('first', array(
            'conditions' => array(
                'Link.id' => $id
            ),
        ));
        if (!$link) {
            throw new NotFoundException(__('Invalid Link.'));
        }

        $user = $this->Link->User->findById($link['Link']['user_id']);
        if (!$user) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user', $user);

        $user_plan = $this->Link->User->Plan->findById($user['User']['plan_id']);
        if (!$user_plan) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user_plan', $user_plan);


        $bundles = $this->Link->Bundle->find('list', array(
            'conditions' => array(
                'Bundle.user_id' => $link['Link']['user_id']
            ),
            'order' => 'Bundle.name ASC'
        ));
        $this->set('bundles', $bundles);

        if ($this->request->is(array('post', 'put'))) {
            $this->Link->id = $id;

            if (!isset($this->request->data['Link']['bundle_id']) || empty($this->request->data['Link']['bundle_id'])) {
                $this->request->data['Link']['bundle_id'] = 0;
            }

            if ($this->Link->save($this->request->data)) {
                $this->Flash->set('Your link has been updated.', array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'edit', $id));
            } else {
                //debug( $this->Link->validationErrors );
                $this->Flash->set('Unable to update your link.', array(
                    'element' => 'error'
                ));
            }
        }

        if (!$this->request->data) {
            $this->request->data = $link;
        }
    }

    /**
     *
     * @param type $id
     * @return type
     * @throws NotFoundException
     */
    public function members_edit($id = null)
    {
        $this->set('website_title', 'Edit Link');

        if (!$id) {
            throw new NotFoundException(__('Invalid Link'));
        }

        $user = $this->Link->User->findById($this->Auth->user('id'));
        if (!$user) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user', $user);

        $user_plan = $this->Link->User->Plan->findById($user['User']['plan_id']);
        if (!$user_plan) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user_plan', $user_plan);

        $link = $this->Link->find('first', array(
            'conditions' => array('Link.user_id' => $this->Auth->user('id'), 'Link.id' => $id),
        ));
        if (!$link) {
            throw new NotFoundException(__('Invalid Link.'));
        }

        $bundles = $this->Link->Bundle->find('list', array(
            'conditions' => array(
                'Bundle.user_id' => $this->Auth->user('id')
            ),
            'order' => 'Bundle.name ASC'
        ));
        $this->set('bundles', $bundles);

        if ($this->request->is(array('post', 'put'))) {
            $this->Link->id = $id;

            if (!isset($this->request->data['Link']['bundle_id']) || empty($this->request->data['Link']['bundle_id'])) {
                $this->request->data['Link']['bundle_id'] = 0;
            }

            $params = array(
                'fieldList' => array('Link.title', 'Link.description', 'Link.password', 'Link.redirection_type', 'Link.bundle_id')
            );
            if ($this->Link->save($this->request->data, true, $params)) {
                $this->Flash->set('Your link has been updated.', array(
                    'element' => 'success'
                ));
                return $this->redirect($this->referer());
            } else {
                //debug( $this->Link->validationErrors );
                $this->Flash->set('Unable to update your link.', array(
                    'element' => 'error'
                ));
            }
        }

        if (!$this->request->data) {
            $this->request->data = $link;
        }
    }

    /**
     * Not finished
     */
    public function members_bulk()
    {
        if ($this->Auth->user('account_type') == 'Free') {
            throw new NotFoundException();
        }

        $bundles = $this->Link->Bundle->find('list', array(
            'conditions' => array(
                'Bundle.user_id' => $this->Auth->user('id')
            ),
            'order' => 'Bundle.name ASC'
        ));
        $this->set('bundles', $bundles);


        if ($this->request->is('post')) {
            if (!isset($this->request->data['Link']['timer']) || empty($this->request->data['Link']['timer'])) {
                $this->request->data['Link']['timer'] = 10;
            }


            if (!isset($this->request->data['Link']['bundle_id']) || empty($this->request->data['Link']['bundle_id'])) {
                $this->request->data['Link']['bundle_id'] = 0;
            }

            $data_links = explode("\n", $this->request->data['Link']['bulk_links']);
            $data = array();
            foreach ($data_links as $data_link) {
                $data[] = array(
                    'Link' => array(
                        'long_url' => $data_link,
                        'bundle_id' => $this->request->data['Link']['bundle_id'],
                        'user_id' => $this->Auth->user('id'),
                        'ip' => get_ip(),
                        'timer' => $this->request->data['Link']['timer']
                    )
                );
            }
            $this->Link->create();
            if ($this->Link->saveAll($data, array('validate' => true))) {
                $this->Flash->set('The link has been saved.', array(
                    'element' => 'success'
                ));
                $this->redirect(array('action' => 'bulk'));
            } else {
                //debug( $this->Link->validationErrors );
                $this->Flash->set('The link could not be saved. Please, try again.', array(
                    'element' => 'error'
                ));
            }
        }
    }

    /**
     *
     * @param type $id
     * @return type
     * @throws NotFoundException
     * @throws MethodNotAllowedException
     */
    public function members_delete($id = null)
    {
        if ($this->Auth->user('account_type') == 'Free') {
            throw new NotFoundException();
        }

        if (!$this->request->is('post')) {
            throw new MethodNotAllowedException();
        }
        $this->Link->id = $id;
        if (!$this->Link->exists()) {
            throw new NotFoundException(__('Invalid Link'));
        }

        if (!$this->Link->isOwnedBy($this->Link->id, $this->Auth->user('id'))) {
            throw new NotFoundException(__('Invalid Link'));
        }

        /**
         * Used to delete associated recoreds
         */
        $this->Link->userId = $this->Auth->user('id');

        if ($this->Link->delete()) {
            $this->Flash->set('Link deleted.', array(
                'element' => 'success'
            ));
            return $this->redirect($this->referer());
        }
        $this->Flash->set('Link was not deleted.', array(
            'element' => 'error'
        ));
        return $this->redirect($this->referer());
    }

    public function admin_delete($id = null)
    {
        if (!$this->request->is('post')) {
            throw new MethodNotAllowedException();
        }
        $this->Link->id = $id;
        if (!$this->Link->exists()) {
            throw new NotFoundException(__('Invalid Link'));
        }

        $link = $this->Link->findById($id);

        /**
         * Used to delete associated recoreds
         */
        $this->Link->userId = $link['Link']['user_id'];

        if ($this->Link->delete()) {
            $this->Flash->set('Link deleted.', array(
                'element' => 'success'
            ));
            return $this->redirect($this->referer());
        }
        $this->Flash->set('Link was not deleted.', array(
            'element' => 'error'
        ));
        return $this->redirect($this->referer());
    }
}
